/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.logd;

import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.servlet.logd.DllExpander;
import com.ibm.hwmca.fw.servlet.logd.ExpanderData;
import com.ibm.hwmca.fw.servlet.logd.GetExpanderData;
import com.ibm.hwmca.fw.servlet.logd.HexExpander;
import com.ibm.hwmca.fw.servlet.logd.LogServlet;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.cparser.ParserObj;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

public class StandardExpander {
    private static final String TRACE_MASKT = "XLDSSTDT";
    private static final String TRACE_MASKF = "XLDSSTDF";
    private static final String TRACE_MASKD = "XLDSSTDD";
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogdServ");
    private static final String _standardTitle = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.standard.title").toString();
    private static final String _standardVersion = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.standard.version.name").toString();
    private static final String _standardProgramName = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.standard.program.name").toString();
    private static final String _standardCurrentProcess = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.standard.currentprocess.name").toString();
    private static final String _standardParentProcess = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.standard.parentprocess.name").toString();
    private static final String _standardCurrentThreadPriority = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.standard.currentthreadpriority.name").toString();
    private static final String _standardCurrentThreadId = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.standard.currentthreadid.name").toString();
    private static final String _standardScreenGroup = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.standard.screengroup.name").toString();
    private static final String _standardSubscreenGroup = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.standard.subscreengroup.name").toString();
    private static final String _standardCurrentForegroundProcess = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.standard.currentforegroundprocess.name").toString();
    private static final String _standardCurrentForegroundScreenGroup = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.standard.currentforegroundscreen.name").toString();
    private Map _map;
    private int PROGRAM_NAME_LENGTH = 51;
    private int USHORT_LEN = 2;
    private int INT_LEN = 4;
    private int CHAR_LEN = 1;
    private int VERSION_LEN = this.USHORT_LEN;
    private int INDEX_VERSION = 0;
    private int INDEX_PROGRAM_NAME = 0;
    private int INDEX_CURRENT_PROCESS_ID = 51;
    private int INDEX_PARENT_PROCESS_ID = 55;
    private int INDEX_CURRENT_THREAD_PRIORITY = 59;
    private int INDEX_CURRENT_THREAD_ID = 63;
    private int INDEX_SCREEN_GROUP = 67;
    private int INDEX_SUBSCREEN_GROUP = 71;
    private int INDEX_CURRENT_FOREGROUND_PROCESS = 75;
    private int INDEX_CURRENT_FOREGROUND_SCREEN_GROUP = 79;
    private int STANDARD_DATA_BLOCK_HMC_LEN = 80;
    private int STANDARD_DATA_BLOCK_SE_LEN = 91;
    private int STANDARD_DATA_BLOCK_HMC_WITH_VERSIONING_LEN = this.STANDARD_DATA_BLOCK_HMC_LEN + this.VERSION_LEN;
    private int STANDARD_DATA_BLOCK_SE_WITH_VERSIONING_LEN = this.STANDARD_DATA_BLOCK_SE_LEN + this.VERSION_LEN;
    private int EXPANDER_STD = 0;
    private int EXPANDER_TEXT = 1;
    private int EXPANDER_HEX = 2;
    private int EXPANDER_REDIRECT = 3;

    public StandardExpander(Map map) throws IOException {
        Trace.trace(TRACE_MASKT, "<> StandardExpander()");
        this._map = map;
        this.displayStandard();
    }

    private int whichExpander(boolean isVersioningSupported, byte[] hexData) {
        int expander = this.EXPANDER_HEX;
        int hexDataLen = hexData.length;
        Trace.trace(TRACE_MASKF, "log(header)  isVersioningSupported flag=" + isVersioningSupported);
        Trace.trace(TRACE_MASKF, "Standard data length=" + hexDataLen);
        if (!isVersioningSupported) {
            if (hexDataLen == this.STANDARD_DATA_BLOCK_HMC_LEN) {
                expander = this.EXPANDER_STD;
            } else if (hexDataLen == this.STANDARD_DATA_BLOCK_SE_LEN) {
                expander = this.EXPANDER_REDIRECT;
            }
        } else {
            if (hexDataLen > this.VERSION_LEN) {
                int version = ParserObj.toIntSwap(hexData, this.VERSION_LEN, this.INDEX_VERSION);
                Trace.trace(TRACE_MASKF, "standard version flag=0x" + HexString.toHex(version));
                if (version == 1) {
                    if (hexDataLen == this.STANDARD_DATA_BLOCK_HMC_WITH_VERSIONING_LEN) {
                        expander = this.EXPANDER_STD;
                    } else if (hexDataLen == this.STANDARD_DATA_BLOCK_SE_WITH_VERSIONING_LEN) {
                        expander = this.EXPANDER_REDIRECT;
                    }
                } else if (version == 2) {
                    expander = this.EXPANDER_STD;
                }
            }
            Trace.trace(TRACE_MASKF, "expander to Display Standard Data=" + expander);
        }
        Trace.trace(TRACE_MASKF, "whichExpander=" + expander);
        return expander;
    }

    private StringBuffer createStandardDataBuffer(PrintWriter out, boolean isVersioningSupported, Log log, byte[] hexData) {
        StringBuffer strBuffer = new StringBuffer();
        int versionSize = 0;
        if (isVersioningSupported) {
            versionSize = this.VERSION_LEN;
            Trace.trace(TRACE_MASKF, "versioning in the log is supported");
            strBuffer.append("<TR><TH align=\"left\">");
            strBuffer.append(_standardVersion + "</TH>");
            strBuffer.append("<TD>");
            strBuffer.append(HexString.toHex(ParserObj.toIntSwap(hexData, this.VERSION_LEN, this.INDEX_VERSION)).toUpperCase());
            strBuffer.append("</TD>");
            strBuffer.append("</TR>");
        }
        strBuffer.append("<TR><TH align=\"left\">");
        strBuffer.append(_standardProgramName + "</TH>");
        strBuffer.append("<TD>");
        strBuffer.append(new String(hexData, versionSize + this.INDEX_PROGRAM_NAME, this.PROGRAM_NAME_LENGTH).trim());
        strBuffer.append("</TD>");
        strBuffer.append("</TR>");
        strBuffer.append("<TR><TH align=\"left\">");
        strBuffer.append(_standardCurrentProcess + "</TH>");
        strBuffer.append("<TD>");
        strBuffer.append(HexString.toHex(ParserObj.toIntSwap(hexData, this.INT_LEN, versionSize + this.INDEX_CURRENT_PROCESS_ID)).toUpperCase());
        strBuffer.append("</TD>");
        strBuffer.append("</TR>");
        strBuffer.append("<TR><TH align=\"left\">");
        strBuffer.append(_standardParentProcess + "</TH>");
        strBuffer.append("<TD>");
        strBuffer.append(HexString.toHex(ParserObj.toIntSwap(hexData, this.INT_LEN, versionSize + this.INDEX_PARENT_PROCESS_ID)).toUpperCase());
        strBuffer.append("</TD>");
        strBuffer.append("</TR>");
        strBuffer.append("<TR><TH align=\"left\">");
        strBuffer.append(_standardCurrentThreadPriority + "</TH>");
        strBuffer.append("<TD>");
        strBuffer.append(HexString.toHex(ParserObj.toIntSwap(hexData, this.INT_LEN, versionSize + this.INDEX_CURRENT_THREAD_PRIORITY)).toUpperCase());
        strBuffer.append("</TD>");
        strBuffer.append("</TR>");
        strBuffer.append("<TR><TH align=\"left\">");
        strBuffer.append(_standardCurrentThreadId + "</TH>");
        strBuffer.append("<TD>");
        strBuffer.append(HexString.toHex(ParserObj.toIntSwap(hexData, this.INT_LEN, versionSize + this.INDEX_CURRENT_THREAD_ID)).toUpperCase());
        strBuffer.append("</TD>");
        strBuffer.append("</TR>");
        strBuffer.append("<TR><TH align=\"left\">");
        strBuffer.append(_standardScreenGroup + "</TH>");
        strBuffer.append("<TD>");
        strBuffer.append(HexString.toHex(ParserObj.toIntSwap(hexData, this.INT_LEN, versionSize + this.INDEX_SCREEN_GROUP)).toUpperCase());
        strBuffer.append("</TD>");
        strBuffer.append("</TR>");
        strBuffer.append("<TR><TH align=\"left\">");
        strBuffer.append(_standardSubscreenGroup + "</TH>");
        strBuffer.append("<TD>");
        strBuffer.append(HexString.toHex(ParserObj.toIntSwap(hexData, this.INT_LEN, versionSize + this.INDEX_SUBSCREEN_GROUP)).toUpperCase());
        strBuffer.append("</TD>");
        strBuffer.append("</TR>");
        strBuffer.append("<TR><TH align=\"left\">");
        strBuffer.append(_standardCurrentForegroundProcess + "</TH>");
        strBuffer.append("<TD>");
        strBuffer.append(HexString.toHex(ParserObj.toIntSwap(hexData, this.INT_LEN, versionSize + this.INDEX_CURRENT_FOREGROUND_PROCESS)).toUpperCase());
        strBuffer.append("</TD>");
        strBuffer.append("</TR>");
        strBuffer.append("<TR><TH align=\"left\">");
        strBuffer.append(_standardCurrentForegroundScreenGroup + "</TH>");
        byte currentForegroundScreenGroup = hexData[versionSize + this.INDEX_CURRENT_FOREGROUND_SCREEN_GROUP];
        strBuffer.append("<TD>");
        strBuffer.append(HexString.toHex(currentForegroundScreenGroup, true));
        strBuffer.append("</TD>");
        strBuffer.append("</TR>");
        return strBuffer;
    }

    private void displayStandard() throws IOException {
        Trace.trace(TRACE_MASKT, "-> LogDisplayerStandard()");
        ExpanderData expanderData = GetExpanderData.getData(this._map);
        if (expanderData.getDataExists()) {
            byte[] hexData = expanderData.getHexData();
            Log log = expanderData.getLog();
            PrintWriter out = expanderData.getResponse().getWriter();
            boolean isVersioningSupported = log.isVersioningSupported();
            int expander = this.whichExpander(isVersioningSupported, hexData);
            if (expander == this.EXPANDER_STD) {
                Trace.trace(TRACE_MASKF, "display standard data using standard displayer.");
                StringBuffer strBuffer = this.createStandardDataBuffer(out, isVersioningSupported, log, hexData);
                out.print("<html> <script src='/js/servlettask/keys.js'></script><head><title>" + _standardTitle + "</title></head>" + "<body onload='window.focus(); hideCancel();' > <pre>" + LogServlet.HTML_BACK + "<br>&nbsp;<br>" + "<TABLE cellspacing = \"2\" cellpadding = \"2\" >" + strBuffer.toString() + "</TABLE>" + "</pre> </body>" + "</html>");
            } else if (expander == this.EXPANDER_REDIRECT) {
                Trace.trace(TRACE_MASKF, "display standard data using old hardware block expander.");
                DllExpander dllExpander = new DllExpander(this._map);
            } else {
                Trace.trace(TRACE_MASKF, "Will display the standard data block has hex.");
                HexExpander hexE = new HexExpander(this._map);
            }
            Trace.trace(TRACE_MASKT, "<- StandardExpander()");
        }
    }
}

